#!/usr/bin/env python
# -*- coding: utf-8 -*- Time-stamp: <2017-11-15 12:28:06 sander>*-

# multirun-volcano:
# Rolf Sander, 2017

##############################################################################

# RUN CONTROL:

##############################################################################

# TODO:

##############################################################################

# from netCDF4 import Dataset
# import matplotlib.pyplot as plt
# #plt.rcParams.update({'figure.max_open_warning': 0}) # 'More than 20 figures'
# from matplotlib.backends.backend_pdf import PdfPages
import os
import subprocess
import shutil # rmtree = rm -fr
import datetime
import sys
# import numpy as np
from glob import glob
# from mecca import mecca
# from caabaplot import caabaplot
from pyteetime import tee
from txt2nc import txt2nc

DONTEDIT = '// This file was created by multirun-volcano, DO NOT EDIT!'
HLINE =  '-' * 78

##############################################################################

def runcmd(cmd, comment, logfile):
    print >> logfile, HLINE
    print >> logfile, cmd
    print >> logfile, HLINE
    print '%-12s' % (comment),
    exitstatus = subprocess.call('time -p '+cmd, stdout=logfile, stderr=logfile, shell=True)
    if (exitstatus == 0):
        print '  ...done'
    else:
        sys.exit('ERROR: nonzero exit status')

##############################################################################

def create_nml(init_scenario, lifetime, numberconc, radius):
    tmp_nml = 'tmp_caaba.nml'
    NMLFILE = open(tmp_nml,'w+', 1) # 1=line-buffered
    print >> NMLFILE, '! -*- f90 -*-'+DONTEDIT
    print >> NMLFILE, "&CAABA"
    print >> NMLFILE, "USE_JVAL    = T"
    print >> NMLFILE, "USE_MECCA   = T"
    print >> NMLFILE, "init_scenario     = 'VOLCANO'"
    print >> NMLFILE, "photo_scenario    = 'VOLCANO'"
    print >> NMLFILE, "drydep_scenario   = 'VOLCANO' ! activate CALL dilute"
    print >> NMLFILE, "temp   = 293.    ! temperature [K]"
    print >> NMLFILE, "press  = 96000.  ! pressure [Pa]"
    print >> NMLFILE, "relhum = 0.8     ! relative humidity [1]"
    print >> NMLFILE, "degree_lat = 11.98"
    print >> NMLFILE, "model_start_day = 80.48"
    print >> NMLFILE, "runtime_str     = '25 minutes'"
    print >> NMLFILE, "timesteplen_str = '2 seconds'"
    print >> NMLFILE, "photrat_channel = 'jval'"
    print >> NMLFILE, "init_spec = 'multirun-volcano/input/" + init_scenario + ".nc'"
    print >> NMLFILE, "nml_exchng = %g" % (1. / (60. * lifetime))
    print >> NMLFILE, "nml_numberconc = %g" % (numberconc)
    print >> NMLFILE, "nml_radius = %g" % (radius)
    print >> NMLFILE, "/"
    NMLFILE.close()
    os.system('ln -fs ' + tmp_nml + ' caaba.nml')

##############################################################################

if __name__ == '__main__':

    # ensure that multirun-volcano.py is started from main caaba/ directory:
    if (not os.path.isfile('multirun-volcano/multirun-volcano.py')):
        sys.exit('ERROR: multirun-volcano.py must be started from caaba ' +
        'directory, preferably via xcaaba')
    timestamp = datetime.datetime.now().strftime('%Y-%m-%d-%H:%M:%S')
    outputdir = 'output/volcano-'+timestamp
    os.mkdir(outputdir)
    logfilename = 'multirun-volcano.log'
    LOGFILE = tee.stdout_start(logfilename) # stdout
    for full_init_scenario in sorted(glob('multirun-volcano/input/*.txt')):
        # remove path and suffix:
        init_scenario = os.path.splitext(os.path.basename(full_init_scenario))[0]
        # convert file with initial mixing ratios from *.txt to *.nc:
        txt2nc('multirun-volcano/input/'+init_scenario)
        # plume lifetime loop:
        for lifetime in (10.,30.,60.): # minutes
            # aerosol loop:
            for numberconc in (3E9, 5E9):
                radius = 0.9E-6
                print 'running init = %s, lifetime = %g, numberconc = %g, radius = %g' % (
                    init_scenario, lifetime, numberconc, radius)
                # create namelist file:
                create_nml(init_scenario, lifetime, numberconc, radius)
                # run the model:
                runcmd('./caaba.exe', 'caaba.exe', LOGFILE)
                # move output into another directory:
                outputsubdir = '%s/%s-%g-%g-%g' % (
                    outputdir, init_scenario, lifetime, numberconc, radius)
                os.mkdir(outputsubdir)
                for ncfile in glob('caaba_*.nc'):
                    shutil.move(ncfile, outputsubdir)
                shutil.copy2('caaba.nml', outputsubdir)
    print 'output is now in: %s' % (outputsubdir)
    tee.stdout_stop()
    shutil.move(logfilename, outputdir)

##############################################################################

# code snippets for debugging:
#qqq+
#sys.exit('END') #qqq
#print os.getcwd() # print current directory
#print os.path.basename(os.getcwd())
#qqq-
